﻿import { getToolBySlug } from "@/lib/tools";
import ToolFrame from "@/components/ToolFrame";
import { notFound } from "next/navigation";

export default function ToolPage({ params }: { params: { slug: string } }) {
  const tool = getToolBySlug(params.slug);
  if (!tool) return notFound();

  return (
    <div className="w-full">
      <ToolFrame src={tool.path} />
    </div>
  );
}

